% Script to produce Figure 1

% This file is part of Code and Data for the numerical experiments in 
% "Frequency-Based Reduced Models from Purely Time-Domain Data via Data Informativity"
% Copyright (C) 2023 Michael S. Ackermann
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)
load RandEx0.mat
n = length(A);

T = 3*n;
t_eval = 0:T;

U = randn(T+1,1);
Y = runDTSys(A,B,C,D,U,t_eval);
w = 0.5;
s = exp(w*1i);
%% Compute Orthogonal Subspace
Hu = HankMat(U,n);
Hy = HankMat(Y,n);
U_trunc = orth([Hu;Hy]);
[U_full, ~, ~] = svd([Hu;Hy],'econ');
G = [Hu;Hy];
%% Compute condition numbers
gamma_sig = calc_gamma(s,n,0);
z = [zeros(n+1,1);-gamma_sig];

U_trunc_z = [U_trunc z];
U_full_z = [U_full z];
Gz = [G z];

S1 = svd(Gz);
S2 = svd(U_trunc_z);
S3 = svd(U_full_z);

n1 = length(S2);
n2 = length(S1);
n3 = length(S3);

%% Plot
load ColorMat.mat

f=figure;
f.Position = [476 445 700 280];
semilogy(S1,'Color',ColorMat(1,:),'LineWidth',2)
hold on
semilogy(S2,'Color',ColorMat(2,:),'LineWidth',2)
semilogy(S3,'--','Color',ColorMat(3,:),'LineWidth',2)
semilogy(1,S1(1),'o','Color',ColorMat(1,:),'MarkerSize',10,'LineWidth',1.5)
semilogy(n2,S1(n2),'o','Color',ColorMat(1,:),'MarkerSize',10,'LineWidth',1.5)
semilogy(1,S2(1),'o','Color',ColorMat(2,:),'MarkerSize',10,'LineWidth',1.5)
semilogy(n1,S2(n1),'o','Color',ColorMat(2,:),'MarkerSize',10,'LineWidth',1.5)
semilogy(1,S3(1),'*','Color',ColorMat(3,:),'MarkerSize',10,'LineWidth',1.5)
semilogy(n3,S3(n3),'*','Color',ColorMat(3,:),'MarkerSize',10,'LineWidth',1.5)
ax = gca;
Default_TW = ax.TickLength;
Default_LW = ax.LineWidth;
ax.TickLength = Default_TW * 2;
ax.LineWidth = Default_LW * 2;
ax.FontSize = 16;
xlabel('$j$','interpreter','latex','fontsize',25)
ylabel('Singular Value','interpreter','latex','fontsize',20)
legend('$[\mathbf G_{n}~\mathbf z(\sigma)]$',...
    '$[\mathbf U_c~\mathbf z(\sigma)]$',...
    '$[\mathbf U~\mathbf z(\sigma)]$',...
    'autoupdate','off','Interpreter','latex','Location','southwest')
ylim([10^-(17),10^(5)])
xlim([-5,205])

%% Report condition numbers
fprintf('-----Condition Numbers------\n')
fprintf('[G_n  z]:  %e\n',S1(1)/S1(end))
fprintf('[U_c  z]:  %e\n',S2(1)/S2(end))
fprintf('[U  z]:    %e\n',S3(1)/S3(end))



